<?php 
	//Get all the headerpics from the database
	include("db.php");
	$picSQL = "SELECT url FROM slider";
    $logon = $dbconnect->prepare($picSQL);
    $logon->execute();
    $returnedPics = $logon->fetchAll(PDO::FETCH_ASSOC);
    //Get the number of news
    $numberOfNewsSQL = "SELECT count(id) AS numb FROM news";
    $logon = $dbconnect->prepare($numberOfNewsSQL);
    $logon->execute();
    $numberOfNewsSQL = $logon->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
	<title>Skotfélag Kópavogs</title>
	<?php include 'assets/includes/header.php'; ?>
</head>
<body>
<?php include 'assets/includes/nav.php'; ?>
	<main>
		<div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
		    <!-- Indicators -->
		    <ol class="carousel-indicators">
		        <?php 
		        	for ($i=0; $i < sizeof($returnedPics); $i++) { 
		        		if ($i == 0) {
		        			echo '<li data-target="#carousel-example-generic" data-slide-to="0" class="active"></li>';
		        		}else{
		        			echo '<li data-target="#carousel-example-generic" data-slide-to="' . $i . '"></li>';
		        		}
		        	}
		        ?>
		    </ol>
  
		    <!-- Wrapper for slides -->
		    <div class="carousel-inner" role="listbox">
		    	<?php
		    		$counter = 0;
		    		foreach ($returnedPics as $temp) {
		    			if ($counter == 0) {
		    				echo "<div class=\"item active\">";
			    			echo "<img class=\"sliderImage\"  src=\"" . $temp['url'] . "\">";
			    			echo "</div>";
		    			}else{
		    				echo "<div class=\"item\">";
			    			echo "<img class=\"sliderImage\" src=\"" . $temp['url'] . "\">";
			    			echo "</div>";
		    			}
		    			$counter++;
		    		}
		    	?>
		    </div>
  
		    <!-- Controls -->
		    <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
		        <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
		        <span class="sr-only">Previous</span>
		    </a>
		    <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
		        <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
		        <span class="sr-only">Next</span>
		    </a>
		</div>
		<div class="threeContainer container-fluid">
			<div class="row">
				<div class="smallNav col-md-2">
					<?php include 'assets/includes/sidebarnav.php'; ?>
				</div>
				<div class="news col-md-8">
					<div class="threeNews">

					</div>
					<ul class="pagination">
						
					</ul>
				</div>
				<div class="advert col-md-2">
					<div class="testText">
						AUGLÝSING
					</div>
				</div>
			</div>
		</div>
	</main>
	<?php include 'assets/includes/footer.php'; ?>
	<script>
		$('.pagination').bootpag({
		    total: <?php echo ceil($numberOfNewsSQL[0]['numb'] / 3); ?>,
		    page: 1
		}).on('page', function(event, num){
			//fetchnews function gets three news stories and returns them properly formatted
			$.ajax({
				url: 'assets/php/fetchNews.php',
				type: 'GET',
				data: {page: num},
			}).done(function(data) {
				$(".threeNews").html(data);
			});
		});
		$.ajax({
				url: 'assets/php/fetchNews.php',
				type: 'GET',
				data: {page: 1},
			}).done(function(data) {
				$(".threeNews").html(data);
			});
	</script>
</body>
</html>